# Negbin_fit2.R
# Fitting the negative binomial to frequency data

# Load necessary libraries
library(ggplot2)
library(MASS)

# Read in data set
nbdata <- read.table(header=T,colClasses=c("numeric","numeric"),text="
y obsfreq
0  24
1  16
2  16 
3  18
4  15
5   9
6   6
7   5
8   3
9   4
10  3
11  0
12  1
")

# Generate offset y values for plot
nbdata <- transform(nbdata,yexp=y-0.1)
nbdata <- transform(nbdata,yobs=y+0.1)

# Print data
nbdata

# Convert tabulated data to raw form for R
ydata <- rep(nbdata[,"y"],nbdata$obsfreq)

# Calculate mean and variance
mean(ydata)
var(ydata)

# Fit negative binomial distribution
# Note that k = size, m = mu
fitout <- fitdistr(ydata,"negative binomial")
fitout

# Calculate expected frequencies
nbdata <- transform(nbdata,nbprob=dnbinom(nbdata$y,size=fitout$estimate[1],mu=fitout$estimate[2]))
nbdata <- transform(nbdata,expfreq=fitout$n*nbprob)

# Print revised data
nbdata

# Generate plot showing frequencies
ggplot(nbdata,aes(yobs,obsfreq))+
geom_bar(stat="identity",width=0.05,fill="blue")+
geom_point(color="blue",size=3)+
geom_bar(aes(yexp,expfreq),stat="identity",width=0.05,fill="red")+
geom_point(aes(yexp,expfreq),color="red",size=3)+
ggtitle("Fitting the negative binomial to frequency data")
